// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for exporting public and secret keys to the clipboard.
//..................................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;

#define POLY24				0x1864cfb

extern	HINSTANCE			hInst;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	BYTE				TempUserId[256];
extern	BYTE				TypeKey;
extern	DWORD				dwRecordLength1;
extern	LPTSTR				lpszNA;
extern	LPBYTE				lpSearchEDI;
extern	TCHAR				szKeyFile[MAX_PATH];
extern	BOOL				bProcessInProgress;
extern	DWORD				dwSource;
extern	COLORREF			crBkgCurrent;
extern	BOOL				bReturnReceipt;
extern	BOOL				bBackupFiles;
extern	BOOL				bProgramRegistered;

CD_STRUCT		CDLine;
DWORD			Table[256];
BOOL			bIncludeBkgClr;
LPBYTE			lpLineFeed = "\n";
LPTSTR			lpszClipboard = "Clipboard";
TCHAR			szClipboardFile[] = "Clipboard.rsakey";
BOOL			bExport;
TCHAR			szBeginTsc[] = "-----BEGIN TSC";
TCHAR			szBeginPgp[] = "-----BEGIN PGP";
TCHAR			szEndTsc[] = "-----END TSC";
TCHAR			szEndPgp[] = "-----END PGP";
TCHAR			szSecret[] = "Secret";
TCHAR			szPublic[] = "Public";

// Public key headers.
//....................
TCHAR			Header[] = "-----BEGIN TSC PUBLIC KEY BLOCK-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Private or Commercial Use - www.topsecretcrypto.com\r\n\r\n";
TCHAR			HeaderP[] = "-----BEGIN TSC PUBLIC KEY BLOCK-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Personal Private Use Only - www.topsecretcrypto.com\r\n\r\n";
TCHAR			Footer[] = "-----END TSC PUBLIC KEY BLOCK-----\r\n";
TCHAR			szMessage1[] = "Owner: %s\n\nThis Public Key was successfully transferred to the clipboard.";
TCHAR			szMessage2[] = "Owner: %s\n\nAn error was encountered while transferring this Public Key to the clipboard.";

// Private key headers.
//.....................
TCHAR			HeaderPriv[] = "-----BEGIN TSC PRIVATE KEY BLOCK-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Private or Commercial Use - www.topsecretcrypto.com\r\n\r\n";
TCHAR			HeaderPrivP[] = "-----BEGIN TSC PRIVATE KEY BLOCK-----\r\nVersion: Top Secret Crypto Gold v4.00 - For Personal Private Use Only - www.topsecretcrypto.com\r\n\r\n";
TCHAR			FooterPriv[] = "-----END TSC PRIVATE KEY BLOCK-----\r\n";
TCHAR			szMessage7[] = "Owner: %s\n\nThis Secret Key was successfully transferred to the clipboard.";
TCHAR			szMessage8[] = "Owner: %s\n\nAn error was encountered while transferring this Secret Key to the clipboard.";

BYTE	BinToAsc[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

BYTE	AscToBin[] = {128, 128, 128, 128, 128, 128, 128, 128,
					  128, 128, 128, 128, 128, 128, 128, 128,
					  128, 128, 128, 128, 128, 128, 128, 128,
					  128, 128, 128, 128, 128, 128, 128, 128,
					  128, 128, 128, 128, 128, 128, 128, 128,
					  128, 128, 128,  62, 128, 128, 128,  63,
					   52,  53,  54,  55,  56,  57,  58,  59,
					   60,  61, 128, 128, 128, 128, 128, 128,
					  128,  00,   1,   2,   3,   4,   5,   6,
					    7,   8,   9,  10,  11,  12,  13,  14,
					   15,  16,  17,  18,  19,  20,  21,  22,
					   23,  24,  25, 128, 128, 128, 128, 128,
					  128,  26,  27,  28,  29,  30,  31,  32,
					   33,  34,  35,  36,  37,  38,  39,  40,
					   41,  42,  43,  44,  45,  46,  47,  48,
					   49,  50,  51};

// Export a public or secret key to the clipboard.
//................................................
BOOL PublicKeyToClipboard(LPBYTE lpKeyBuffer)
{
	BOOL			bResult = FALSE;
	LPBYTE			lpKeyBufferDup;
	LPBYTE			lpTrustPacket;
	DWORD			dwCtb_Byte;
	BYTE			PreviousPacket;
	BYTE			HoldPacket;
	BYTE			TempCTB;
	DWORD			dwArmorLines;
	DWORD			dwMemNeeded;
	HGLOBAL			hClipboardMem;
	LPVOID			lpClipboardMem;
	LPBYTE			lpClipboardMemDup;
	int				iTemp;
	int				iResult;
	BOOL			bMem;
	DWORD			dwErrCode;
	HANDLE			hClipboard;
	TCHAR			szBuffer[1024];
	TCHAR			szFmt[512];

	if (BPC())
	{
		goto ClipEnd;
	}
	// Set up the beginning and ending default headers.
	//.................................................
	if (TypeKey == PUBLIC_KEY)
	{
		__asm
		{
			mov		esi,offset szBeginTsc
			mov		edi,offset Header
			mov		ecx,14
			rep		movsb

			mov		esi,offset szBeginTsc
			mov		edi,offset HeaderP
			mov		ecx,14
			rep		movsb

			mov		esi,offset szEndTsc
			mov		edi,offset Footer
			mov		ecx,12
			rep		movsb
		}
		// Ask if we want to export headers and trailers compatable with PGP.
		// Must be all Md5 signatures and less than or equal to 4,096 bytes.
		//...................................................................
		if (CDLine.bPGPCompatible && CDLine.NUMBER_OF_BITS <= 4096)
		{
			LoadString(hInst,IDS_EXPORT_PGP_COMP,(LPTSTR)&szFmt,sizeof(szFmt));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szFmt,CDLine.ID,
						    CDLine.NUMBER_OF_BITS,szPublic);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)&szBuffer,
									 MB_ICONQUESTION | MB_HELP | MB_YESNOCANCEL,
									 MB_ICONQUESTION,0);
			if (iResult == IDYES)
			{
				__asm
				{
					mov		esi,offset szBeginPgp
					mov		edi,offset Header
					mov		ecx,14
					rep		movsb

					mov		esi,offset szBeginPgp
					mov		edi,offset HeaderP
					mov		ecx,14
					rep		movsb

					mov		esi,offset szEndPgp
					mov		edi,offset Footer
					mov		ecx,12
					rep		movsb
				}
			}
			else if (iResult == IDCANCEL)
			{
				goto ClipEnd;
			}
		}
	}
	else
	{
		// Process the secret key.
		//........................
		__asm
		{
			mov		esi,offset szBeginTsc
			mov		edi,offset HeaderPriv
			mov		ecx,14
			rep		movsb

			mov		esi,offset szBeginTsc
			mov		edi,offset HeaderPriv
			mov		ecx,14
			rep		movsb

			mov		esi,offset szEndTsc
			mov		edi,offset FooterPriv
			mov		ecx,12
			rep		movsb
		}
		// Ask if we want to export headers and trailers compatable with PGP.
		// Must be all Md5 signatures and less than or equal to 4,096 bytes.
		//...................................................................
		if (CDLine.bPGPCompatible && CDLine.NUMBER_OF_BITS <= 4096)
		{
			LoadString(hInst,IDS_EXPORT_PGP_COMP,(LPTSTR)&szFmt,sizeof(szFmt));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szFmt,CDLine.ID,
							CDLine.NUMBER_OF_BITS,szSecret);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)&szBuffer,
									 MB_ICONQUESTION | MB_HELP | MB_YESNOCANCEL,
									 MB_ICONQUESTION,0);
			if (iResult == IDYES)
			{
				__asm
				{
					mov		esi,offset szBeginPgp
					mov		edi,offset HeaderPriv
					mov		ecx,14
					rep		movsb

					mov		esi,offset szBeginPgp
					mov		edi,offset HeaderPrivP
					mov		ecx,14
					rep		movsb

					mov		esi,offset szEndPgp
					mov		edi,offset FooterPriv
					mov		ecx,12
					rep		movsb
				}
			}
			else if (iResult == IDCANCEL)
			{
				goto ClipEnd;
			}
		}
	}
	// We are exporting a key. Do not add return receipt value.
	//.........................................................
	bExport = TRUE;

	// Setup the user id in TempUserId for the export 
	// message box.
	//...............................................
	CopyMemory(&TempUserId,&CDLine.ID,sizeof(CDLine.ID));

	// If we have a public key we have to set all the trust
	// packets to not initialized. Except the owner trust 
	// disabled bit.
	//.....................................................
	if (TypeKey == PUBLIC_KEY)
	{
		lpKeyBufferDup = lpKeyBuffer;

		while(TRUE)
		{
			// Check for end of the key.
			//..........................
			if (*lpKeyBufferDup == 0)
			{
				break;
			}

			__asm
			{
				mov		edi,lpKeyBufferDup
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		HoldPacket,al
				mov		TempCTB,al
			}
			if (TempCTB != CTB_TRUST)
			{
				GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup
					add		edi,CTB_SIZE
					add		edi,edx
					add		edi,eax
					mov		lpKeyBufferDup,edi
				}
			}
			else
			{
				// Set all trust bytes to not initialized, except if
				// key is disabled. Leave disabled bit set in owner
				// trust packet.
				//..................................................
				GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup
					add		edi,CTB_SIZE
					add		edi,edx
					mov		lpTrustPacket,edi
					add		edi,eax
					mov		lpKeyBufferDup,edi
				}
				if (PreviousPacket == CTB_PUBLIC_KEY)
				{
					__asm
					{
						mov		edi,lpTrustPacket
						and		byte ptr [edi],DISABLED_BIT
					}
				}
				else
				{
					__asm
					{
						mov		edi,lpTrustPacket
						mov		byte ptr [edi],NOT_INITIALIZED
					}
				}
			}
			PreviousPacket = HoldPacket;
		}
	}
	// Determine the number of armor lines required.
	//..............................................
	__asm
	{
		xor		edx,edx
		mov		eax,dwRecordLength1
		mov		ecx,48
		div		ecx
		cmp		edx,0
		je		L1
		inc		eax
	L1:	mov		dwArmorLines,eax
	}
	// Figure out how much memory we need and then armor the public key.
	//..................................................................
	dwMemNeeded = ((dwArmorLines * 66) + 1024);
	hClipboardMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,dwMemNeeded);
	if (hClipboardMem == NULL)
	{
		ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
		goto ClipEnd;
	}
	lpClipboardMem = GlobalLock(hClipboardMem);
	if (lpClipboardMem == NULL)
	{
		ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		GlobalFree(hClipboardMem);
		goto ClipEnd;
	}
	ZeroMemory(lpClipboardMem,dwMemNeeded);

	// Put in the header.
	//...................
	lpClipboardMemDup = lpClipboardMem;

	if (TypeKey == PUBLIC_KEY)
	{
		if (bProgramRegistered)
		{
			CopyMemory(lpClipboardMemDup,&Header,lstrlen((LPCTSTR)&Header));
		}
		else
		{
			CopyMemory(lpClipboardMemDup,&HeaderP,lstrlen((LPCTSTR)&HeaderP));
		}
		iTemp = lstrlen((LPCTSTR)&Header);
	}
	else
	{
		if (bProgramRegistered)
		{
			CopyMemory(lpClipboardMemDup,&HeaderPriv,lstrlen((LPCTSTR)&HeaderPriv));
		}
		else
		{
			CopyMemory(lpClipboardMemDup,&HeaderPrivP,lstrlen((LPCTSTR)&HeaderPrivP));
		}
		iTemp = lstrlen((LPCTSTR)&HeaderPriv);
	}
	
	// Calculate the address for inserting the key in radix-64 format.
	//................................................................
	__asm
	{
		mov		ecx,iTemp
		mov		edi,lpClipboardMemDup
		add		edi,ecx
		mov		lpClipboardMemDup,edi
	}
	// Armor the public key.
	//......................
	lpClipboardMemDup = ArmorBuffer(lpKeyBuffer,lpClipboardMemDup,dwRecordLength1);

	// Put in the footer.
	//...................
	if (TypeKey == PUBLIC_KEY)
	{
		CopyMemory(lpClipboardMemDup,&Footer,lstrlen((LPCTSTR)&Footer));
	}
	else
	{
		CopyMemory(lpClipboardMemDup,&FooterPriv,lstrlen((LPCTSTR)&FooterPriv));
	}
	// Unlock the memory for the clipboard.
	//.....................................
	bMem = GlobalUnlock(hClipboardMem);
	if (!bMem)
	{
		dwErrCode = GetLastError();
		if (dwErrCode != NO_ERROR)
		{
			SetLastError(dwErrCode);
			ErrorProcedure(lpszClipboard,IDS_UNLOCKMEMORY,MB_OK);
			goto ClipEnd;
		}
	}
	// Open the Clipboard.
	//....................
	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto ClipEnd;
	}
	bResult = EmptyClipboard();
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_EMPTYCLIPBOARD,MB_OK);
		goto ClipEnd;
	}
	hClipboard = SetClipboardData(CF_TEXT,hClipboardMem);
	if (!hClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_SETCLIPBOARD,MB_OK);
	}
	bResult = CloseClipboard();

	if (bResult && hClipboard)
	{
		if (TypeKey == PUBLIC_KEY)
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szMessage1,
						    &TempUserId);
		}
		else
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szMessage7,
							&TempUserId);
		}
	}
	else
	{
		if (TypeKey == PUBLIC_KEY)
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szMessage2,
						    &TempUserId);
		}
		else
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szMessage8,
							&TempUserId);
		}
	}
	MessageBoxProc(hMainWindow,IDS_CLOSECLIPBOARD,(UINT)&szBuffer,
				   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);

	ClipEnd:

	bExport = FALSE;

	return(bResult);
}

// Initialize the crc table.
//..........................
VOID Crc24Init(LPDWORD Table)
{
	ULONG i, j;
	DWORD h;

	Table[0] = 0;
	Table[1] = h = POLY24;

	for (i = 2; i < 256; i *= 2) 
	{
		if ((h <<= 1) & 0x1000000)		// h <<= 1 (mod poly)
		{
			h ^= POLY24;
		}
		for (j = 0; j < i; j++)
		{
			Table[i+j] = Table[j] ^ h;
		}
	}
}

// Update a CRC to reflect the addition of some more bytes.
//.........................................................
DWORD Crc24Update(DWORD crc, LPBYTE Buffer, DWORD len)
{

	if (!Table[1])
	{
		Crc24Init((LPDWORD)&Table);
	}
	while (len--)
	{
		crc = crc << 8 ^ Table[*Buffer++ ^ (BYTE)(crc >> 16)];
	}
	return (crc & 0xffffff);
}

// Armor 3 raw bytes into 4
// If armoring n < 3 bytes, make the trailers zero, and
// then overwrite the trailing 3-n bytes with '='
//.....................................................
VOID ArmorMorsel(LPBYTE Raw, LPBYTE Armor)
{
        Armor[0] = BinToAsc[Raw[0] >> 2 & 0x3f];
        Armor[1] = BinToAsc[(Raw[0] << 4 & 0x30) + (Raw[1] >> 4 & 0x0f)];
        Armor[2] = BinToAsc[(Raw[1] << 2 & 0x3c) + (Raw[2] >> 6 & 0x03)];
        Armor[3] = BinToAsc[Raw[2] & 0x3f];
}

// The method here to do the armoring is somewhat tricky.
// Most lines just have dwinlen = 48 which maps to 48*4/3 = 64
// output characters.  But the last line has a short inlen.
// This leads to a truncated last group, which looks like one of:
// xx== (if the last group contains 1 byte - 4 bits of padding are zero)
// xxx= (if the last group contains 2 bytes - 2 bits of padding are zero)
// xxxx (if the last group contains 3 bytes)
// To do this, we make sure that we've added an extra 0 byte to the
// end of the input, then encode it in blocks of 3 bytes, then note by
// how much the encoding overshot the input length, len - inlen.
// This is 2, 1, or 0.  Overwrite that many trailing characters with '='.
// Then a newline can be appended for output.
//.......................................................................
DWORD ArmorLine(LPBYTE lpin, DWORD dwinlen, LPBYTE lpout)
{
	DWORD		dwlen;
	int			t;
	LPBYTE		lpout0 = lpout;

	// Fill the output buffer from the input buffer.
	//..............................................
	for (dwlen = 0; dwlen < dwinlen; dwlen += 3) 
	{
		ArmorMorsel (lpin, lpout);
		lpin += 3;
		lpout += 4;
	}

	// Now back up and erase any overrun.
	//...................................
	t = (int)(dwinlen - dwlen);		// Zero or negative.
	while (t)
	{
		lpout[t++] = '=';
	}
	      
	return (lpout - lpout0);
}

// Armor a buffer of data.
//........................
LPBYTE ArmorBuffer(LPBYTE lpInBuffer, LPBYTE lpOutBuffer, DWORD dwLength)
{
	DWORD		dwArmor;
	DWORD		dwReturn;
	DWORD		Crc24;

	// Lets get the 24 bit crc for the key.
	//.....................................
	Crc24 = CRC24_INIT;
	Crc24 = Crc24Update(Crc24,lpInBuffer,dwLength);

	while(dwLength)
	{
		if (dwLength > 48)
		{
			dwArmor = 48;
			dwLength -= 48;
		}
		else
		{
			dwArmor = dwLength;
			dwLength = 0;
		}
		dwReturn = ArmorLine(lpInBuffer,dwArmor,lpOutBuffer);

		__asm
		{
			mov		eax,dwArmor
			mov		edi,lpInBuffer
			add		edi,eax
			mov		lpInBuffer,edi
			mov		ecx,dwReturn
			mov		edi,lpOutBuffer
			mov		ax,0x0a0d
			add		edi,ecx
			stosw
			cmp		dwLength,0
			jnz		L1
			mov		al,'='
			stosb
		L1:	mov		lpOutBuffer,edi
		}
	}
	// Add the Crc24 value to the end. MSB first.
	//...........................................
	__asm
	{
		mov		eax,Crc24
		mov		ebx,Crc24
		mov		ecx,Crc24
		and		eax,0xff0000
		and		ebx,0xff00
		and		ecx,0xff
		shr		eax,16
		shl		ecx,16
		or		eax,ebx
		or		eax,ecx
		mov		Crc24,eax
	}
	dwReturn = ArmorLine((LPBYTE)&Crc24,3,lpOutBuffer);

	// See if we have the background color of a rich text edit control to add.
	//........................................................................
	if (bIncludeBkgClr)
	{
		Crc24 = crBkgCurrent;

		__asm
		{
			mov		eax,Crc24
			mov		ebx,Crc24
			mov		ecx,Crc24
			and		eax,0xff0000
			and		ebx,0xff00
			and		ecx,0xff
			shr		eax,16
			shl		ecx,16
			or		eax,ebx
			or		eax,ecx
			mov		Crc24,eax

			// Add an equal sign before the background color.
			//...............................................
			mov		ecx,dwReturn
			mov		edi,lpOutBuffer
			mov		al,'='
			add		edi,ecx
			stosb
			mov		lpOutBuffer,edi
		}
		dwReturn = ArmorLine((LPBYTE)&Crc24,3,lpOutBuffer);
	}
	// Add the return receipt value ONLY for e-mail messages.
	//.......................................................
	__asm
	{
		mov		ecx,dwReturn
		mov		edi,lpOutBuffer
		add		edi,ecx
		cmp		bExport,1
		je		L4
		mov		al,'='
		stosb
		cmp		bReturnReceipt,0
		jz		L2
		mov		al,'1'
		jmp		L3
	L2:	mov		al,'0'
	L3:	stosb

		// Add in the final line feeds and carriage returns.
		//..................................................
	L4:	mov		eax,0x0a0d0a0d
		stosd
		mov		lpOutBuffer,edi
	}
	return(lpOutBuffer);
}

// Import a public key from the clipboard to the public key ring.
//...............................................................
VOID ImportAPublicKey()
{
	BOOL			bResult;
	DWORD			dwCrc24;
	DWORD			dwKeyLength;
	LPBYTE			lpClipboard;
	HGLOBAL			hGlobal;
	LPBYTE			lpMyClipboard = 0;
	DWORD			dwLength;
	DWORD			dwSearchLength;
	DWORD			dwTemp = 0;
	int				i;
	UINT			uFormat = 0;
	LPBYTE			lpDestination = 0;
	DWORD			dwCrc24Dup;
	LPBYTE			lpTemp;
	HANDLE			hFile = 0;
	DWORD			dwBytesWritten;

	bProcessInProgress = TRUE;
	lpTemp = (LPBYTE)&dwCrc24Dup;

	if (BPC())
	{
		goto ImportEnd;
	}
	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto ImportEnd;
	}
	while(TRUE)
	{
		uFormat = EnumClipboardFormats(uFormat);
		if (uFormat == 0)
		{
			if (GetLastError() != NO_ERROR)
			{
				ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
				goto ImportEnd;
			}
			else
			{
				SetLastError(IDS_NOTEXTFORMAT);
				ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
				goto ImportEnd;
			}
		}
		if (uFormat == CF_TEXT)
		{
			break;
		}
	}
	// We have a text format to get, so do it.
	//........................................
	hGlobal = GetClipboardData(uFormat);
	if (!hGlobal)
	{
		ErrorProcedure(lpszClipboard,IDS_GETCLIPBOARD,MB_OK);
		goto ImportEnd;
	}
	lpClipboard = GlobalLock(hGlobal);
	if (!lpClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto ImportEnd;
	}
	// Get the length of the clipboard so we can allocate our own memory block.
	//.........................................................................
	dwLength = (lstrlen((LPCTSTR)lpClipboard) + 1);

	lpMyClipboard = AllocateMemory(dwLength);
	if (!lpMyClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto ImportEnd;
	}
	// Copy the clipboard to our memory block.
	//........................................
	CopyMemory(lpMyClipboard,lpClipboard,dwLength);

	GlobalUnlock(hGlobal);

	// Close the clipboard.
	//.....................
	bResult = CloseClipboard();
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_CLOSECLIPBOARD,MB_OK);
	}
	dwSearchLength = dwLength;

	// Scan for at least 4 line feed characters in the public message.
	//................................................................
	__asm
	{
		mov		ecx,dwSearchLength
		mov		esi,lpMyClipboard
	L1:	lodsb
		cmp		al,0x00
		je		L3
		cmp		al,0x0a
		jne		L2
		inc		dwTemp
	L2:	dec		ecx
		jnz		L1
	}
	L3:

	if (dwTemp < 4)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Check for the trailer first to see if we have a valid public key block.
	//........................................................................
	bResult = SearchFor((LPBYTE)&Footer,8,(LPBYTE)lpMyClipboard,dwLength);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Search for the last part of the trailing header.
	//.................................................
	lpClipboard = lpSearchEDI;
	dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);

	bResult = SearchFor((LPBYTE)&Footer[13],21,(LPBYTE)lpClipboard,dwSearchLength);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Check the header to  see if we have a valid public key block.
	//..............................................................
	bResult = SearchFor((LPBYTE)&Header,10,(LPBYTE)lpMyClipboard,dwLength);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Look for the public key block.
	//...............................
	lpClipboard = lpSearchEDI;
	__asm
	{
		add		lpClipboard,15
	}
	bResult = SearchFor((LPBYTE)&Header[15],21,lpClipboard,30);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Now we have to get past the version line and find the start of the key.
	// Search for line feeds with a first character of 'm' following.
	//........................................................................
	dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);

	i = 5;
	while(i > 0)
	{
		bResult = SearchFor(lpLineFeed,1,lpClipboard,dwSearchLength);
		if (!bResult)
		{
			SetLastError(IDS_NOPUBLICKEYINCLIP);
			ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
			goto ImportEnd;
		}
		lpClipboard = lpSearchEDI;
		lpClipboard++;
		if (*lpClipboard == 'm')
		{
			break;
		}
		dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);
		i--;
	}
	if (*lpClipboard != 'm')
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// lpClipboard points to the start of the public key block.
	// Decode the block to get our key and crc24 value.
	//.........................................................
	lpDestination = AllocateMemory(dwLength + 4096);
	if (!lpDestination)
	{
		goto ImportEnd;
	}
	dwCrc24 = CRC24_INIT;

	// Dearmor the buffer.
	//....................
	lpClipboard = DearmorBuffer(lpClipboard,lpDestination,&dwKeyLength);
	if (lpClipboard == 0)
	{
		SetLastError(IDS_DEARMORBUFFERERROR);
		ErrorProcedure(lpszClipboard,IDS_READ,MB_OK);
		goto ImportEnd;
	}
	// We are finished with the conversion of the key.
	// Calculate the crc24 value.
	//................................................
	dwCrc24 = Crc24Update(dwCrc24,lpDestination,dwKeyLength);

	// Backup the pointer 2 spaces so we can search for a \n.
	//.......................................................
	lpClipboard--;
	lpClipboard--;

	// Now retrieve the crc24 value from the clipboard buffer.
	// lpClipboard points to the = after the key and before
	// the crc24 value. Could be more than one.
	//........................................................
	bResult = SearchFor(lpLineFeed,1,lpClipboard,10);
	if (!bResult)
	{
		SetLastError(IDS_NOVALIDCRC24);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	lpClipboard = lpSearchEDI;
	lpClipboard++;
	if (*lpClipboard != '=')
	{
		SetLastError(IDS_NOVALIDCRC24);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	lpClipboard++;

	dwCrc24Dup = GetCrc24(lpClipboard);

	if (dwCrc24 != dwCrc24Dup)
	{
		SetLastError(IDS_CRC24NOMATCH);
		ErrorProcedure(lpszClipboard,IDS_COMPARE,MB_OK);
		goto ImportEnd;
	}
	// We have a valid public key, maybe. Create a temporary file on disk.
	//....................................................................
	ZeroMemory(&szKeyFile,MAX_PATH);
	GetTempPath(MAX_PATH,(LPTSTR)&szKeyFile);
	StringCbCatEx((LPTSTR)&szKeyFile,sizeof(szKeyFile),(LPCTSTR)&szClipboardFile,NULL,NULL,
				   dwStringSafeFlag);
	hFile = CreateMyFile((LPTSTR)&szKeyFile,GENERIC_READ | GENERIC_WRITE,0,
						  NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto ImportEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szKeyFile,hFile,lpDestination,dwKeyLength,
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto ImportEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szKeyFile,hFile);
	if (!bResult)
	{
		goto ImportEnd;
	}
	hFile = 0;

	// Call the add key file to key ring procedure.
	//.............................................
	BackupFiles(BEFORE_CHECK);

	dwSource = FROM_CLIPBOARD;
	AddKeysToAKeyRing();

	if (bBackupFiles)
	{
		BackupFiles(AFTER_CHECK);
		bBackupFiles = FALSE;
	}
	// Delete the temporary file.
	//...........................
	DeleteMyFile((LPTSTR)&szKeyFile);

	ImportEnd:

	if (hFile)
	{
		CloseMyHandle((LPTSTR)&szKeyFile,hFile);
		DeleteMyFile((LPTSTR)&szKeyFile);
	}
	if (lpMyClipboard)
	{
		ZeroMemory(lpMyClipboard,dwLength);
		DeallocateMemory(lpMyClipboard);
	}
	if (lpDestination)
	{
		ZeroMemory(lpDestination,(dwLength + 4096));
		DeallocateMemory(lpDestination);
	}
	bProcessInProgress = FALSE;
}

// Import a secret key from the clipboard to the secret key ring.
//...............................................................
VOID ImportASecretKey()
{
	BOOL			bResult;
	DWORD			dwCrc24;
	DWORD			dwKeyLength;
	LPBYTE			lpClipboard;
	HGLOBAL			hGlobal;
	LPBYTE			lpMyClipboard = 0;
	DWORD			dwLength;
	DWORD			dwSearchLength;
	DWORD			dwTemp = 0;
	int				i;
	UINT			uFormat = 0;
	LPBYTE			lpDestination = 0;
	DWORD			dwCrc24Dup;
	LPBYTE			lpTemp;
	HANDLE			hFile = 0;
	DWORD			dwBytesWritten;

	bProcessInProgress = TRUE;
	lpTemp = (LPBYTE)&dwCrc24Dup;

	if (BPC())
	{
		goto ImportEnd;
	}
	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto ImportEnd;
	}
	while(TRUE)
	{
		uFormat = EnumClipboardFormats(uFormat);
		if (uFormat == 0)
		{
			if (GetLastError() != NO_ERROR)
			{
				ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
				goto ImportEnd;
			}
			else
			{
				SetLastError(IDS_NOTEXTFORMAT);
				ErrorProcedure(lpszClipboard,IDS_ENUMCLIPFORMATS,MB_OK);
				goto ImportEnd;
			}
		}
		if (uFormat == CF_TEXT)
		{
			break;
		}
	}
	// We have a text format to get, so do it.
	//........................................
	hGlobal = GetClipboardData(uFormat);
	if (!hGlobal)
	{
		ErrorProcedure(lpszClipboard,IDS_GETCLIPBOARD,MB_OK);
		goto ImportEnd;
	}
	lpClipboard = GlobalLock(hGlobal);
	if (!lpClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto ImportEnd;
	}
	// Get the length of the clipboard so we can allocate our own memory block.
	//.........................................................................
	dwLength = (lstrlen((LPCTSTR)lpClipboard) + 1);

	lpMyClipboard = AllocateMemory(dwLength);
	if (!lpMyClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto ImportEnd;
	}
	// Copy the clipboard to our memory block.
	//........................................
	CopyMemory(lpMyClipboard,lpClipboard,dwLength);

	GlobalUnlock(hGlobal);

	// Close the clipboard.
	//.....................
	bResult = CloseClipboard();
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_CLOSECLIPBOARD,MB_OK);
	}
	dwSearchLength = dwLength;

	// Scan for at least 4 line feed characters in the public message.
	//................................................................
	__asm
	{
		mov		ecx,dwSearchLength
		mov		esi,lpMyClipboard
	L1:	lodsb
		cmp		al,0x00
		je		L3
		cmp		al,0x0a
		jne		L2
		inc		dwTemp
	L2:	dec		ecx
		jnz		L1
	}
	L3:

	if (dwTemp < 4)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Check for the trailer first to see if we have a valid private key block.
	//.........................................................................
	bResult = SearchFor((LPBYTE)&FooterPriv,8,(LPBYTE)lpMyClipboard,dwLength);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Search for the last part of the trailing header.
	//.................................................
	lpClipboard = lpSearchEDI;
	dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);

	bResult = SearchFor((LPBYTE)&FooterPriv[13],22,(LPBYTE)lpClipboard,dwSearchLength);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Check the header to  see if we have a valid private key block.
	//...............................................................
	bResult = SearchFor((LPBYTE)&HeaderPriv,10,(LPBYTE)lpMyClipboard,dwLength);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Look for the private key block.
	//................................
	lpClipboard = lpSearchEDI;
	__asm
	{
		add		lpClipboard,15
	}
	bResult = SearchFor((LPBYTE)&HeaderPriv[15],22,lpClipboard,30);
	if (!bResult)
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// Now we have to get past the version line and find the start of the key.
	// Search for line feeds with a first character of 'l' following.
	//........................................................................
	dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);

	i = 5;
	while(i > 0)
	{
		bResult = SearchFor(lpLineFeed,1,lpClipboard,dwSearchLength);
		if (!bResult)
		{
			SetLastError(IDS_NOPUBLICKEYINCLIP);
			ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
			goto ImportEnd;
		}
		lpClipboard = lpSearchEDI;
		lpClipboard++;
		if (*lpClipboard == 'l')
		{
			break;
		}
		dwSearchLength = (dwLength + lpMyClipboard - lpClipboard);
		i--;
	}
	if (*lpClipboard != 'l')
	{
		SetLastError(IDS_NOPUBLICKEYINCLIP);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	// lpClipboard points to the start of the secret key block.
	// Decode the block to get our key and crc24 value.
	//.........................................................
	lpDestination = AllocateMemory(dwLength + 4096);
	if (!lpDestination)
	{
		ErrorProcedure(lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
		goto ImportEnd;
	}
	dwCrc24 = CRC24_INIT;

	// Dearmor the buffer.
	//....................
	lpClipboard = DearmorBuffer(lpClipboard,lpDestination,&dwKeyLength);
	if (lpClipboard == 0)
	{
		SetLastError(IDS_DEARMORBUFFERERROR);
		ErrorProcedure(lpszClipboard,IDS_READ,MB_OK);
		goto ImportEnd;
	}
	// We are finished with the conversion of the key.
	// Calculate the crc24 value.
	//................................................
	dwCrc24 = Crc24Update(dwCrc24,lpDestination,dwKeyLength);

	// Backup the pointer 2 spaces so we can search for a \n.
	//.......................................................
	lpClipboard--;
	lpClipboard--;

	// Now retrieve the crc24 value from the clipboard buffer.
	// lpClipboard points to the = after the key and before
	// the crc24 value. Could be more than one.
	//........................................................
	bResult = SearchFor(lpLineFeed,1,lpClipboard,10);
	if (!bResult)
	{
		SetLastError(IDS_NOVALIDCRC24);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	lpClipboard = lpSearchEDI;
	lpClipboard++;
	if (*lpClipboard != '=')
	{
		SetLastError(IDS_NOVALIDCRC24);
		ErrorProcedure(lpszClipboard,IDS_SEARCHFOR,MB_OK);
		goto ImportEnd;
	}
	lpClipboard++;

	dwCrc24Dup = GetCrc24(lpClipboard);

	if (dwCrc24 != dwCrc24Dup)
	{
		SetLastError(IDS_CRC24NOMATCH);
		ErrorProcedure(lpszClipboard,IDS_COMPARE,MB_OK);
		goto ImportEnd;
	}
	// We have a valid secret key, maybe. Create a temporary file on disk.
	//....................................................................
	ZeroMemory(&szKeyFile,MAX_PATH);
	GetTempPath(MAX_PATH,(LPTSTR)&szKeyFile);
	StringCbCatEx((LPTSTR)&szKeyFile,sizeof(szKeyFile),(LPCTSTR)&szClipboardFile,NULL,NULL,
				   dwStringSafeFlag);
	hFile = CreateMyFile((LPTSTR)&szKeyFile,GENERIC_READ | GENERIC_WRITE,0,
						  NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto ImportEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szKeyFile,hFile,lpDestination,dwKeyLength,
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto ImportEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szKeyFile,hFile);
	if (!bResult)
	{
		goto ImportEnd;
	}
	hFile = 0;

	// Call the add key file to key ring procedure.
	//.............................................
	BackupFiles(BEFORE_CHECK);

	dwSource = FROM_CLIPBOARD;
	AddKeysToAKeyRing();

	if (bBackupFiles)
	{
		BackupFiles(AFTER_CHECK);
		bBackupFiles = FALSE;
	}
	// Delete the temporary file.
	//...........................
	DeleteMyFile((LPTSTR)&szKeyFile);

	ImportEnd:

	if (hFile)
	{
		CloseMyHandle((LPTSTR)&szKeyFile,hFile);
		DeleteMyFile((LPTSTR)&szKeyFile);
	}
	if (lpMyClipboard)
	{
		ZeroMemory(lpMyClipboard,dwLength);
		DeallocateMemory(lpMyClipboard);
	}
	if (lpDestination)
	{
		ZeroMemory(lpDestination,(dwLength + 4096));
		DeallocateMemory(lpDestination);
	}
	bProcessInProgress = FALSE;
}


// Dearmor a buffer. Returns with pointer to first = which is end of key.
//.......................................................................
LPBYTE DearmorBuffer(LPBYTE lpInBuffer,LPBYTE lpOutBuffer, LPDWORD lpOutLength)
{
	LPBYTE		lpInBuff;
	DWORD		dwLength;
	UINT		c1, c2, c3, c4, j;
	BOOL		bResult = FALSE;

	dwLength = 0;
	lpInBuff = lpInBuffer;

	// Four input characters go into each THREE output characters.
	//............................................................
	while(*lpInBuff != '=')
	{
		if (*lpInBuff == '\r' || *lpInBuff == '\n')
		{
			++lpInBuff;
			continue;
		}
		if (*lpInBuff == 0)
		{
			goto DearmorEnd;
		}
		if (*lpInBuff & 0x80 || (c1 = AscToBin[*lpInBuff]) & 0x80)
		{
			goto DearmorEnd;
		}
		++lpInBuff;

		if (*lpInBuff & 0x80 || (c2 = AscToBin[*lpInBuff]) & 0x80)
		{
			goto DearmorEnd;
		}
		// Check for the next character being an =.
		//.........................................
		if (*++lpInBuff == '=')
		{
			c3 = c4 = 0;
			dwLength += 1;	
		}
		else if (*lpInBuff & 0x80 || (c3 = AscToBin[*lpInBuff]) & 0x80)
		{
			goto DearmorEnd;
		}
		else
		{
			if (*++lpInBuff == '=')
			{
				c4 = 0;
				dwLength += 2;
			}
			else if (*lpInBuff & 0x80 || (c4 = AscToBin[*lpInBuff]) & 0x80)
			{
				goto DearmorEnd;
			}
			else
			{
				dwLength += 3;
			}
		}
		// Transfer the transformed bytes to the output buffer.
		//.....................................................
		j = (c1 << 2) | (c2 >> 4);
		*lpOutBuffer++ = j;
		j = (c2 << 4) | (c3 >> 2);
		*lpOutBuffer++ = j;
		j = (c3 << 6) | c4;
		*lpOutBuffer++ = j;

		// If we are at the end, get out of here.
		//.......................................
		if (*lpInBuff == '=')
		{
			break;
		}
		else
		{
			++lpInBuff;
		}
	}
	bResult = TRUE;
	*lpOutLength = dwLength;

	DearmorEnd:

	if (!bResult)
	{
		lpInBuff = 0;
	}
	return(lpInBuff);
}

// Get the crc24 value from the buffer.
//.....................................
DWORD GetCrc24(LPBYTE lpInBuff)
{
	UINT		c1, c2, c3, c4, j;
	BYTE		CrcBuf[4];
	LPBYTE		lpOutBuffer;
	DWORD		ChkCrc = -1;

	lpOutBuffer = CrcBuf;

	if (*lpInBuff & 0x80 || (c1 = AscToBin[*lpInBuff]) & 0x80)
	{
		goto GetCrcEnd;
	}
	++lpInBuff;

	if (*lpInBuff & 0x80 || (c2 = AscToBin[*lpInBuff]) & 0x80)
	{
		goto GetCrcEnd;
	}
	++lpInBuff;

	if (*lpInBuff & 0x80 || (c3 = AscToBin[*lpInBuff]) & 0x80)
	{
		goto GetCrcEnd;
	}
	++lpInBuff;

	if (*lpInBuff & 0x80 || (c4 = AscToBin[*lpInBuff]) & 0x80)
	{
		goto GetCrcEnd;
	}
	// Transfer the transformed bytes to the output buffer.
	//.....................................................
	j = (c1 << 2) | (c2 >> 4);
	*lpOutBuffer++ = j;
	j = (c2 << 4) | (c3 >> 2);
	*lpOutBuffer++ = j;
	j = (c3 << 6) | c4;
	*lpOutBuffer++ = j;

	ChkCrc = 0;

	ChkCrc = (((long) CrcBuf[0] << 16) & 0xff0000L) +
			 ((CrcBuf[1] << 8) & 0xff00L) + (CrcBuf[2] & 0xffL);

	GetCrcEnd:

	return(ChkCrc);
}
